<?php declare(strict_types=1);
require_once __DIR__ . '/../inc/config.php';
$error = '';
if (($_SERVER['REQUEST_METHOD'] ?? '') === 'POST') {
  verify_csrf();
  $email = trim($_POST['email'] ?? '');
  $password = $_POST['password'] ?? '';
  if (attempt_login($email, $password)) { header('Location: ' . url('admin/settings.php')); exit; }
  else { $error = 'ইমেইল/পাসওয়ার্ড সঠিক নয়'; }
}
?>
<!DOCTYPE html>
<html lang="bn">
<head>
  <meta charset="UTF-8"><meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Admin Login</title>
  <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@400;700&display=swap" rel="stylesheet">
  <style>
    body{font-family:'Hind Siliguri',sans-serif;background:#f3f4f6;margin:0;display:flex;align-items:center;justify-content:center;height:100vh}
    .card{background:#fff;padding:26px;border-radius:14px;box-shadow:0 6px 20px rgba(0,0,0,0.08);width:360px}
    h2{margin:0 0 10px}.row{margin:10px 0}
    input{width:100%;padding:12px;border:1px solid #e5e7eb;border-radius:10px}
    .btn{width:100%;padding:12px;border:0;border-radius:10px;background:#2c3e50;color:#fff;font-weight:700;cursor:pointer}
    .alert{padding:10px;border-radius:10px;margin:8px 0;background:#fee2e2}
  </style>
</head>
<body>
  <div class="card">
    <h2>Admin Login</h2>
    <?php if($error): ?><div class="alert"><?=h($error)?></div><?php endif; ?>
    <form method="POST">
      <?= csrf_field(); ?>
      <div class="row"><input name="email" type="email" placeholder="Email" required></div>
      <div class="row"><input name="password" type="password" placeholder="Password" required></div>
      <button class="btn" type="submit">Login</button>
    </form>
  </div>
</body>
</html>
