<?php declare(strict_types=1);
require_once __DIR__ . '/../inc/config.php';
require_login();
$settings = load_settings();
$admin = load_admin();
$success = $error = '';
if (($_SERVER['REQUEST_METHOD'] ?? '') === 'POST') {
  verify_csrf();
  $settings['site_url'] = trim($_POST['site_url'] ?? $settings['site_url']);
  $settings['headline'] = trim($_POST['headline'] ?? $settings['headline']);
  $settings['headline_font_size'] = max(10, min(150, (int)($_POST['headline_font_size'] ?? $settings['headline_font_size'])));
  $settings['headline_color'] = $_POST['headline_color'] ?? $settings['headline_color'];
  $settings['date_locale'] = $_POST['date_locale'] ?? $settings['date_locale'];
  foreach (['show_bg','show_logo','show_date','show_url','show_headline','show_toolbar','hide_form_image','hide_form_input'] as $b) {
    $settings[$b] = isset($_POST[$b]) ? true : false;
  }
  if (!empty($_FILES['bg_image'])) { $p = handle_upload($_FILES['bg_image']); if ($p) $settings['bg_image_path'] = $p; }
  if (!empty($_FILES['logo_image'])) { $p = handle_upload($_FILES['logo_image']); if ($p) $settings['logo_image_path'] = $p; }
  if (!empty($_FILES['default_main_image'])) { $p = handle_upload($_FILES['default_main_image']); if ($p) $settings['default_main_image_path'] = $p; }
  if (!save_settings($settings)) { $error = 'সেটিংস সেভ করতে সমস্যা হয়েছে'; } else { $success = '✅ সেটিংস সেভ হয়েছে'; }

  $new_email = trim($_POST['new_email'] ?? '');
  $new_password = $_POST['new_password'] ?? '';
  if ($new_email || $new_password) {
    if ($new_email) $admin['email'] = $new_email;
    if ($new_password) $admin['password_sha256'] = hash('sha256', $new_password);
    if (save_admin($admin)) $success .= ' | অ্যাডমিন আপডেট হয়েছে'; else $error .= ' | অ্যাডমিন আপডেট ব্যর্থ';
  }
}
?>
<!DOCTYPE html>
<html lang="bn">
<head>
  <meta charset="UTF-8"><meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Admin • Settings</title>
  <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@400;700&display=swap" rel="stylesheet">
  <style>
    body{font-family:'Hind Siliguri',sans-serif;background:#f6f7fb;margin:0;color:#111}
    header{background:#2c3e50;color:#fff;padding:16px 20px;display:flex;align-items:center;justify-content:space-between}
    header a, header form button{color:#2c3e50;background:#fff;text-decoration:none;border:0;padding:8px 12px;border-radius:10px;font-weight:700;cursor:pointer}
    .container{max-width:960px;margin:24px auto;padding:0 16px}
    .card{background:#fff;border:1px solid #e5e7eb;border-radius:14px;box-shadow:0 4px 16px rgba(0,0,0,0.06);padding:20px;margin-bottom:18px}
    .grid{display:grid;grid-template-columns:1fr 1fr;gap:16px}
    .row{display:flex;gap:12px;align-items:center;margin:10px 0}
    label{font-weight:700;min-width:160px}
    input[type="text"],input[type="number"],input[type="color"],input[type="email"],input[type="password"]{width:100%;padding:10px;border:1px solid #d1d5db;border-radius:10px}
    input[type="file"]{border:1px dashed #d1d5db;padding:10px;border-radius:10px;width:100%;background:#fafafa}
    .switch{display:flex;align-items:center;gap:10px;margin:6px 0}
    .btn{padding:10px 14px;border:0;border-radius:10px;cursor:pointer;font-weight:700}
    .btn.primary{background:#2c3e50;color:#fff}
    .alert{padding:10px;border-radius:10px;margin:8px 0}
    .alert.success{background:#dcfce7}
    .alert.error{background:#fee2e2}
    small{color:#6b7280}
  </style>
</head>
<body>
  <header>
    <h2>⚙️ ফটোকার্ড • Admin Panel</h2>
    <form method="POST" action="<?=h(url('admin/logout.php'))?>"><?= csrf_field(); ?><button type="submit">Logout</button></form>
  </header>

  <div class="container">
    <?php if($success): ?><div class="alert success"><?=h($success)?></div><?php endif; ?>
    <?php if($error): ?><div class="alert error"><?=h($error)?></div><?php endif; ?>

    <form method="POST" enctype="multipart/form-data">
      <?= csrf_field(); ?>
      <div class="card">
        <h3>General</h3>
        <div class="grid">
          <div>
            <div class="row"><label>🌐 সাইট URL</label><input name="site_url" type="text" value="<?=h($settings['site_url'])?>"></div>
            <div class="row"><label>📰 ডিফল্ট শিরোনাম</label><input name="headline" type="text" value="<?=h($settings['headline'])?>"></div>
            <div class="row"><label>🔠 ফন্ট সাইজ</label><input name="headline_font_size" type="number" min="10" max="150" value="<?=h((string)$settings['headline_font_size'])?>"></div>
            <div class="row"><label>🎨 ফন্ট কালার</label><input name="headline_color" type="color" value="<?=h($settings['headline_color'])?>"></div>
            <div class="row"><label>📅 Date Locale</label><input name="date_locale" type="text" value="<?=h($settings['date_locale'])?>"></div>
          </div>
          <div>
            <div class="switch"><input name="show_bg" type="checkbox" <?= $settings['show_bg']?'checked':'' ?>><label>ব্যাকগ্রাউন্ড দেখান</label></div>
            <div class="switch"><input name="show_logo" type="checkbox" <?= $settings['show_logo']?'checked':'' ?>><label>লোগো দেখান</label></div>
            <div class="switch"><input name="show_date" type="checkbox" <?= $settings['show_date']?'checked':'' ?>><label>তারিখ দেখান</label></div>
            <div class="switch"><input name="show_url" type="checkbox" <?= $settings['show_url']?'checked':'' ?>><label>ওয়েবসাইট দেখান</label></div>
            <div class="switch"><input name="show_headline" type="checkbox" <?= $settings['show_headline']?'checked':'' ?>><label>হেডলাইন দেখান</label></div>
            <div class="switch"><input name="show_toolbar" type="checkbox" <?= $settings['show_toolbar']?'checked':'' ?>><label>হেডলাইন টুলবার</label></div>
            <hr>
            <div class="switch"><input name="hide_form_image" type="checkbox" <?= $settings['hide_form_image']?'checked':'' ?>><label>Hide Form Image</label></div>
            <div class="switch"><input name="hide_form_input" type="checkbox" <?= $settings['hide_form_input']?'checked':'' ?>><label>Hide Input Form</label></div>
            <small>নোট: Input Form হাইড করলেও Front পেজ ডিফল্ট/URL param থেকে কাজ করবে।</small>
          </div>
        </div>
      </div>

      <div class="card">
        <h3>Images</h3>
        <div class="grid">
          <div>
            <label>🖼️ Background Image</label>
            <?php if(!empty($settings['bg_image_path'])): ?>
              <div><img src="<?=h(url($settings['bg_image_path']))?>" style="height:60px;border-radius:8px;border:1px solid #e5e7eb"></div>
            <?php endif; ?>
            <input type="file" name="bg_image" accept="image/*">
          </div>
          <div>
            <label>🔖 Logo Image</label>
            <?php if(!empty($settings['logo_image_path'])): ?>
              <div><img src="<?=h(url($settings['logo_image_path']))?>" style="height:60px;border-radius:8px;border:1px solid #e5e7eb"></div>
            <?php endif; ?>
            <input type="file" name="logo_image" accept="image/*">
          </div>
          <div>
            <label>📸 Default Main Image (optional)</label>
            <?php if(!empty($settings['default_main_image_path'])): ?>
              <div><img src="<?=h(url($settings['default_main_image_path']))?>" style="height:60px;border-radius:8px;border:1px solid #e5e7eb"></div>
            <?php endif; ?>
            <input type="file" name="default_main_image" accept="image/*">
          </div>
        </div>
      </div>

      <div class="card">
        <h3>Admin Account</h3>
        <div class="row"><label>Email</label><input name="new_email" type="email" value="<?=h($admin['email'])?>"></div>
        <div class="row"><label>New Password</label><input name="new_password" type="password" placeholder="(চেঞ্জ না করতে ফাঁকা রাখুন)"></div>
      </div>

      <div><button class="btn primary" type="submit">💾 Save</button></div>
    </form>
  </div>
</body>
</html>
