<?php declare(strict_types=1);
// inc/auth.php — file-based admin auth (SHA-256 demo)
function admin_file(): string { return STORAGE_PATH . '/admin.json'; }
function load_admin(): array {
  $data = read_json(admin_file(), []);
  if (empty($data)) {
    $data = ['email'=>'admin@example.com', 'password_sha256'=>hash('sha256','Admin@12345')];
    write_json(admin_file(), $data);
  }
  return $data;
}
function save_admin(array $data): bool { return write_json(admin_file(), $data); }
function is_logged_in(): bool { return !empty($_SESSION['admin_logged_in']); }
function require_login(): void {
  if (!is_logged_in()) { header('Location: ' . url('admin/login.php')); exit; }
}
function attempt_login(string $email, string $password): bool {
  $admin = load_admin();
  $ok = (strcasecmp($admin['email'] ?? '', $email) === 0)
        && (hash('sha256', $password) === ($admin['password_sha256'] ?? ''));
  if ($ok) { $_SESSION['admin_logged_in']=true; $_SESSION['admin_email']=$admin['email']??''; session_regenerate_id(true); }
  return $ok;
}
function logout(): void {
  $_SESSION = [];
  if (ini_get("session.use_cookies")) {
    $p = session_get_cookie_params();
    setcookie(session_name(), '', time()-42000, $p["path"], $p["domain"], $p["secure"], $p["httponly"]);
  }
  session_destroy();
}
