<?php declare(strict_types=1);
// inc/config.php — bootstrap (no BOM, strict_types at line 1)

define('APP_NAME', 'Photocard');
define('BASE_PATH', __DIR__ . '/..');
define('STORAGE_PATH', BASE_PATH . '/storage');
define('UPLOADS_PATH', STORAGE_PATH . '/uploads');

// ---- Compute base URL path from filesystem (works in subfolders like /auto-pc) ----
$__doc = isset($_SERVER['DOCUMENT_ROOT']) ? realpath($_SERVER['DOCUMENT_ROOT']) : '';
$__baseFs = realpath(BASE_PATH);
if ($__doc && $__baseFs && strpos($__baseFs, $__doc) === 0) {
    $__rel = str_replace('\\', '/', substr($__baseFs, strlen($__doc)));
    $__rel = '/' . ltrim($__rel, '/');
    define('BASE_URL_PATH', rtrim($__rel === '/' ? '' : $__rel, '/'));
} else {
    // Fallback: use running script dir but strip trailing /admin for admin pages
    $__dir = str_replace('\\','/', dirname($_SERVER['SCRIPT_NAME'] ?? ''));
    $__dir = rtrim($__dir, '/');
    $__dir = preg_replace('#/admin$#', '', $__dir);
    define('BASE_URL_PATH', rtrim($__dir, '/'));
}

// ---- Ensure stable session cookie path across / and /admin ----
$__cookiePath = BASE_URL_PATH ?: '/';
if (PHP_VERSION_ID >= 70300) {
    session_set_cookie_params([
        'lifetime' => 0,
        'path' => $__cookiePath,
        'secure' => (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off'),
        'httponly' => true,
        'samesite' => 'Lax',
    ]);
} else {
    session_set_cookie_params(0, $__cookiePath);
}

session_start();

// Ensure folders
if (!is_dir(STORAGE_PATH)) { @mkdir(STORAGE_PATH, 0777, true); }
if (!is_dir(UPLOADS_PATH)) { @mkdir(UPLOADS_PATH, 0777, true); }

// URL helpers
function base_url(): string { return BASE_URL_PATH; }
function url(string $path=''): string { $path = '/' . ltrim($path, '/'); return (BASE_URL_PATH ? BASE_URL_PATH : '') . $path; }
function asset(string $path): string { return url($path); }

require_once __DIR__ . '/util.php';
require_once __DIR__ . '/auth.php';

$settings = load_settings();

// CSRF
if (empty($_SESSION['_csrf'])) {
  $_SESSION['_csrf'] = bin2hex(random_bytes(16));
}
function csrf_token(): string { return $_SESSION['_csrf'] ?? ''; }
function csrf_field(): string { return '<input type="hidden" name="_csrf" value="' . htmlspecialchars(csrf_token()) . '">'; }
function verify_csrf(): void {
  if (($_SERVER['REQUEST_METHOD'] ?? '') === 'POST') {
    $token = $_POST['_csrf'] ?? '';
    if (!$token || !hash_equals($_SESSION['_csrf'] ?? '', $token)) {
      http_response_code(419);
      exit('CSRF token mismatch');
    }
  }
}
