<?php declare(strict_types=1);
// inc/util.php
function read_json(string $path, $default = []) {
  if (!file_exists($path)) return $default;
  $txt = file_get_contents($path);
  $data = json_decode($txt, true);
  return is_array($data) ? $data : $default;
}
function write_json(string $path, $data): bool {
  $tmp = json_encode($data, JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE);
  return (bool) file_put_contents($path, $tmp);
}
function load_settings(): array {
  $file = STORAGE_PATH . '/settings.json';
  $defaults = [
    "site_url" => "news.techbari.com",
    "headline" => "আপনার শিরোনাম যেখানে থাকবে",
    "headline_font_size" => 30,
    "headline_color" => "#000000",
    "date_locale" => "bn-BD",
    "bg_image_path" => "assets/images/default-bg.jpg",
    "logo_image_path" => "assets/images/logo.png",
    "default_main_image_path" => "",
    "show_bg" => true,
    "show_logo" => true,
    "show_date" => true,
    "show_url" => true,
    "show_headline" => true,
    "show_toolbar" => true,
    "hide_form_image" => false,
    "hide_form_input" => false
  ];
  return array_merge($defaults, read_json($file, $defaults));
}
function save_settings(array $data): bool {
  $file = STORAGE_PATH . '/settings.json';
  return write_json($file, $data);
}
function h($s) { return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }
function handle_upload(array $file): ?string {
  if (empty($file['tmp_name']) || ($file['error'] ?? UPLOAD_ERR_OK) !== UPLOAD_ERR_OK) return null;
  $ext = pathinfo($file['name'] ?? '', PATHINFO_EXTENSION);
  $name = 'up_' . bin2hex(random_bytes(6)) . '.' . strtolower($ext ?: 'bin');
  $destAbs = UPLOADS_PATH . '/' . $name;
  if (!move_uploaded_file($file['tmp_name'], $destAbs)) return null;
  return 'storage/uploads/' . $name;
}
