<?php declare(strict_types=1);
require_once __DIR__ . '/inc/config.php';
$S = $settings;
?>
<!DOCTYPE html>
<html lang="bn">
<head>
  <meta charset="UTF-8"><meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>ফটোকার্ড জেনারেটর</title>
  <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@400;700&display=swap" rel="stylesheet">
  <script src="https://html2canvas.hertzen.com/dist/html2canvas.min.js"></script>
  <style>
    body { font-family:'Hind Siliguri',sans-serif; margin:0; padding:20px; background:linear-gradient(135deg,#f0f4f7,#d9e2ec); }
    h2 { text-align:center; margin-bottom:8px; font-size:28px; color:#2c3e50; }
    .topbar{display:flex;justify-content:center;gap:10px;margin-bottom:20px}
    .topbar a{padding:8px 12px;border:1px solid #2c3e50;border-radius:10px;text-decoration:none;color:#2c3e50;font-weight:700}
    .wrapper{ display:flex; flex-wrap:wrap; justify-content:center; align-items:flex-start; gap:30px; }
    .card-container{ position:relative; width:800px; height:800px; border-radius:16px; overflow:hidden; box-shadow:0 8px 20px rgba(0,0,0,0.15); background-color:#fff; flex-shrink:0; }
    .bg-img{ position:absolute; top:0; left:0; width:100%; height:100%; object-fit:cover; z-index:0; }
    .logo{ position:absolute; top:20px; right:30px; width:120px; z-index:2; }
    .main-image{ position:absolute; top:90px; left:30px; width:740px; height:410px; object-fit:cover; border:6px solid #fff; border-top-right-radius:60px; border-bottom-left-radius:60px; border-top-left-radius:10px; border-bottom-right-radius:10px; box-shadow:0 8px 20px rgba(0,0,0,0.4); }
    .headline{ position:absolute; top:530px; left:50%; transform:translateX(-50%); width:90%; font-size:30px; line-height:1.4; font-weight:700; color:black; text-align:center; z-index:3; user-select:text; }
    .headline:focus{ outline:2px dashed #2c3e50; outline-offset:2px; }
    .date{ position:absolute; bottom:20px; left:30px; font-size:23px; font-weight:600; color:#000; z-index:3; }
    .url{ position:absolute; bottom:20px; right:30px; font-size:23px; font-weight:600; color:#000; z-index:3; }
    .form-section{ max-width:400px; background:#ffffff; padding:30px 40px 30px 30px; border-radius:12px; box-shadow:0 4px 12px rgba(0,0,0,0.1); font-size:16px; flex:1; min-width:280px; }
    .form-group{ margin-bottom:20px; text-align:left; }
    .form-group label{ display:block; margin-bottom:6px; font-weight:600; color:#333; font-size:15px; }
    .form-section input,.form-section textarea{ width:100%; padding:12px; font-size:16px; border:1px solid #ccc; border-radius:8px; box-shadow:0 2px 6px rgba(0,0,0,0.05); font-family:'Hind Siliguri',sans-serif; }
    .form-section textarea{ resize:vertical; min-height:80px; }
    .form-section button{ width:100%; padding:12px; font-size:16px; background:#2c3e50; color:white; border:none; border-radius:8px; cursor:pointer; transition:0.3s; font-weight:bold; }
    .form-section button:hover{ background:#1a242f; }
    @media (max-width:1020px){ .wrapper{ flex-direction:column; align-items:center; } .card-container{ transform:scale(0.95); } }
    @media (max-width:600px){ .card-container{ transform:scale(0.85); } .form-section{ width:100%; padding:20px; } }
    .editor-handle{ position:absolute; width:14px; height:14px; background:#ffffff; border:2px solid #2c3e50; border-radius:50%; z-index:10; box-shadow:0 2px 6px rgba(0,0,0,0.15); }
    .editor-handle.move{ cursor:grab; } .editor-handle.move:active{ cursor:grabbing; }
    .editor-handle.resize{ cursor:nwse-resize; }
    .editor-toolbar{ position:absolute; display:none; align-items:center; gap:6px; background:#ffffff; border:1px solid #e5e7eb; border-radius:10px; padding:6px; box-shadow:0 8px 20px rgba(0,0,0,0.12); z-index:11; }
    .editor-toolbar button{ border:1px solid #e5e7eb; background:#fff; padding:6px 8px; border-radius:8px; font-weight:700; cursor:pointer; }
    .editor-toolbar button:hover{ background:#f3f4f6; }
    .ui-ignore{ pointer-events:auto; }
  </style>
</head>
<body>
  <h2>🌟 ফটোকার্ড জেনারেটর</h2>
  <div class="topbar">
    <a href="<?=h(url('admin/settings.php'))?>" target="_blank">⚙️ Admin</a>
    <a href="#" id="exportCardBtn">🖼️ শুধু কার্ড Export</a>
  </div>

  <div class="wrapper">
    <div id="card" class="card-container">
      <?php if(!empty($S['show_bg'])): ?>
      <img id="bgImageEl" class="bg-img" src="<?=h(url($S['bg_image_path']))?>" crossorigin="anonymous">
      <?php endif; ?>

      <?php if(!empty($S['show_logo'])): ?>
      <img id="logoImage" class="logo" src="<?=h(url($S['logo_image_path']))?>" crossorigin="anonymous">
      <?php endif; ?>

      <img id="mainImage" class="main-image" src="<?=h($S['default_main_image_path']? url($S['default_main_image_path']) : '')?>" crossorigin="anonymous" style="<?= !empty($S['hide_form_image']) ? '' : '' ?>">

      <?php if(!empty($S['show_headline'])): ?>
      <div id="headlineText" class="headline" contenteditable="true" spellcheck="false"><?=h($S['headline'])?></div>
      <?php endif; ?>

      <?php if(!empty($S['show_date'])): ?><div id="dateText" class="date"></div><?php endif; ?>
      <?php if(!empty($S['show_url'])): ?><div id="urlText" class="url"><?=h($S['site_url'])?></div><?php endif; ?>

      <?php if(!empty($S['show_toolbar'])): ?>
      <div id="moveHandle" class="editor-handle move ui-ignore" title="Drag to move"></div>
      <div id="resizeHandle" class="editor-handle resize ui-ignore" title="Drag to resize"></div>
      <div id="editorToolbar" class="editor-toolbar ui-ignore">
        <button type="button" data-cmd="bold">B</button>
        <button type="button" data-cmd="italic"><i>I</i></button>
        <button type="button" data-cmd="underline"><u>U</u></button>
        <span style="width:6px;"></span>
        <button type="button" data-align="left">L</button>
        <button type="button" data-align="center">C</button>
        <button type="button" data-align="right">R</button>
      </div>
      <?php endif; ?>
    </div>

    <?php if(empty($S['hide_form_input'])): ?>
    <div class="form-section" id="formPanel">
      <div class="form-group" style="<?= !empty($S['hide_form_image']) ? 'display:none;' : '' ?>">
        <label for="mainImageInput">📸 মেইন ইমেজ (740 × 410)</label>
        <input type="file" id="mainImageInput" accept="image/*">
      </div>

      <div class="form-group">
        <label for="headlineInput">📰 শিরোনাম</label>
        <textarea id="headlineInput" placeholder="শিরোনাম লিখুন"><?=h($S['headline'])?></textarea>
      </div>

      <div class="form-group">
        <label for="headlineFontSize">🔠 হেডলাইন ফন্ট সাইজ (px)</label>
        <input type="number" id="headlineFontSize" value="<?=h((string)$S['headline_font_size'])?>" min="10" max="150">
      </div>

      <div class="form-group">
        <label for="headlineColor">🎨 হেডলাইন ফন্ট কালার</label>
        <input type="color" id="headlineColor" value="<?=h($S['headline_color'])?>">
      </div>

      <div class="form-group">
        <label for="dateInput">📅 তারিখ (আজকের তারিখ বসাতে ফাঁকা রাখুন)</label>
        <input type="text" id="dateInput" placeholder="">
      </div>

      <div class="form-group">
        <label for="urlInput">🌐 ওয়েবসাইট</label>
        <input type="text" id="urlInput" value="<?=h($S['site_url'])?>" placeholder="যেমন: trishal24.com">
      </div>

      <?php if(!empty($S['show_logo'])): ?>
      <div class="form-group">
        <label for="logoInput">🔖 লোগো ইমেজ</label>
        <input type="file" id="logoInput" accept="image/*">
      </div>
      <?php endif; ?>

      <button onclick="generateCard()">Generate & Download</button>
    </div>
    <?php endif; ?>
  </div>

  <script>
    const SETTINGS = {
      siteUrl: <?= json_encode($S['site_url']) ?>,
      headline: <?= json_encode($S['headline']) ?>,
      headlineFontSize: <?= (int)$S['headline_font_size'] ?>,
      headlineColor: <?= json_encode($S['headline_color']) ?>,
      dateLocale: <?= json_encode($S['date_locale']) ?>,
      showToolbar: <?= !empty($S['show_toolbar']) ? 'true':'false' ?>,
      hideFormImage: <?= !empty($S['hide_form_image']) ? 'true':'false' ?>,
      hideFormInput: <?= !empty($S['hide_form_input']) ? 'true':'false' ?>,
    };

    const mainImageInput = document.getElementById('mainImageInput');
    const logoInput = document.getElementById('logoInput');

    if (mainImageInput) {
      mainImageInput.addEventListener('change', function () {
        const file = this.files[0];
        const reader = new FileReader();
        reader.onload = (e) => { const el = document.getElementById('mainImage'); if (el) { el.src = e.target.result; el.style.display=''; } };
        if (file) reader.readAsDataURL(file);
      });
    }
    if (logoInput) {
      logoInput.addEventListener('change', function () {
        const file = this.files[0];
        const reader = new FileReader();
        reader.onload = (e) => { const el = document.getElementById('logoImage'); if (el) el.src = e.target.result; };
        if (file) reader.readAsDataURL(file);
      });
    }

    function generateCard() {
      const headlineEl = document.getElementById('headlineText');
      const headlineInputEl = document.getElementById('headlineInput');

      if (headlineEl && headlineInputEl) {
        headlineInputEl.value = headlineEl.innerText;
      }

      const headline = headlineInputEl ? headlineInputEl.value : (headlineEl ? headlineEl.innerText : '');
      const dateInputVal = (document.getElementById('dateInput') || {value:''}).value.trim();
      const urlVal = (document.getElementById('urlInput') || {value: SETTINGS.siteUrl}).value;

      const today = new Date();
      const defaultDate = today.toLocaleDateString(SETTINGS.dateLocale || 'bn-BD', { day:'numeric', month:'long', year:'numeric' });
      const finalDate = dateInputVal !== '' ? dateInputVal : defaultDate;

      if (headlineEl) {
        headlineEl.innerText = headline || 'শিরোনাম দেওয়া হয়নি';
        const fontSize = (document.getElementById('headlineFontSize') || {value: SETTINGS.headlineFontSize}).value;
        headlineEl.style.fontSize = fontSize + 'px';
        const color = (document.getElementById('headlineColor') || {value: SETTINGS.headlineColor}).value || '#000000';
        headlineEl.style.color = color;
      }

      const dateEl = document.getElementById('dateText');
      if (dateEl) dateEl.innerText = finalDate;
      const urlEl = document.getElementById('urlText');
      if (urlEl) urlEl.innerText = urlVal || SETTINGS.siteUrl || window.location.hostname;

      html2canvas(document.getElementById('card'), {
        useCORS:true, allowTaint:true, backgroundColor:null,
        ignoreElements: (el)=> el.classList && el.classList.contains('ui-ignore')
      }).then(canvas => {
        const link = document.createElement('a'); link.download='photocard.png'; link.href=canvas.toDataURL(); link.click();
      });
    }

    // live controls
    const hFont = document.getElementById('headlineFontSize');
    const hColor = document.getElementById('headlineColor');
    const hInput = document.getElementById('headlineInput');
    const hText  = document.getElementById('headlineText');
    if (hFont) hFont.addEventListener('input', function(){ if (hText){ hText.style.fontSize = this.value + 'px'; updateEditorUI(); } });
    if (hColor) hColor.addEventListener('input', function(){ if (hText){ hText.style.color = this.value; } });
    if (hInput) hInput.addEventListener('input', function(){ if (hText){ hText.innerText = this.value; updateEditorUI(); } });
    if (hText)  hText.addEventListener('input', function(){ if (hInput){ hInput.value = this.innerText; updateEditorUI(); } });

    // drag/resize
    const card = document.getElementById('card');
    const moveHandle = document.getElementById('moveHandle');
    const resizeHandle = document.getElementById('resizeHandle');
    const toolbar = document.getElementById('editorToolbar');

    let dragState = { dragging:false, offsetX:0, offsetY:0 };
    let resizeState = { resizing:false, startY:0, startFont: 30 };
    function clamp(v,min,max){ return Math.max(min, Math.min(max, v)); }
    function px(n){ return Math.round(n) + 'px'; }
    function updateEditorUI(){
      if (!hText || !SETTINGS.showToolbar) return;
      const cardRect = card.getBoundingClientRect();
      const rect = hText.getBoundingClientRect();
      document.getElementById('moveHandle').style.left = px(rect.left - cardRect.left - 10);
      document.getElementById('moveHandle').style.top  = px(rect.top  - cardRect.top - 18);
      document.getElementById('resizeHandle').style.left = px(rect.right - cardRect.left - 7);
      document.getElementById('resizeHandle').style.top  = px(rect.bottom - cardRect.top - 7);
      const centerX = rect.left + rect.width/2 - cardRect.left;
      toolbar.style.left = px(centerX - toolbar.offsetWidth/2 || centerX);
      toolbar.style.top  = px((rect.top - cardRect.top) - 44);
    }
    let headlineHovering=false;
    if (hText) {
      hText.addEventListener('mouseenter', () => { headlineHovering=true; if(SETTINGS.showToolbar){ toolbar.style.display='flex'; updateEditorUI(); } });
      hText.addEventListener('mouseleave', () => { headlineHovering=false; if(document.activeElement!==hText) toolbar.style.display='none'; });
      hText.addEventListener('focus', () => { if(SETTINGS.showToolbar){ toolbar.style.display='flex'; updateEditorUI(); } });
      hText.addEventListener('blur',  () => { if(!headlineHovering) toolbar.style.display='none'; });
    }
    window.addEventListener('resize', updateEditorUI);
    if (moveHandle) moveHandle.addEventListener('mousedown', (e)=>{
      e.preventDefault();
      const rect = hText.getBoundingClientRect(); const cardRect = card.getBoundingClientRect();
      dragState.dragging = true; dragState.offsetX = e.clientX - (rect.left - cardRect.left); dragState.offsetY = e.clientY - (rect.top - cardRect.top); document.body.style.userSelect='none';
    });
    if (resizeHandle) resizeHandle.addEventListener('mousedown', (e)=>{
      e.preventDefault(); resizeState.resizing=true; resizeState.startY = e.clientY; const currentFont = parseFloat(window.getComputedStyle(hText).fontSize) || SETTINGS.headlineFontSize; resizeState.startFont=currentFont; document.body.style.userSelect='none';
    });
    document.addEventListener('mousemove', (e)=>{
      if (dragState.dragging && hText) {
        const cardRect = card.getBoundingClientRect();
        let newLeft = e.clientX - dragState.offsetX; let newTop = e.clientY - dragState.offsetY;
        const maxLeft = card.clientWidth - hText.offsetWidth; const maxTop = card.clientHeight - hText.offsetHeight;
        newLeft = clamp(newLeft, 0, Math.max(0, maxLeft)); newTop = clamp(newTop, 0, Math.max(0, maxTop));
        hText.style.left = px(newLeft); hText.style.top = px(newTop); updateEditorUI();
      } else if (resizeState.resizing && hText) {
        const deltaY = e.clientY - resizeState.startY; let newFont = resizeState.startFont + deltaY*0.5;
        newFont = clamp(newFont, 10, 150); hText.style.fontSize = newFont + 'px'; const fEl = document.getElementById('headlineFontSize'); if (fEl) fEl.value = Math.round(newFont); updateEditorUI();
      }
    });
    document.addEventListener('mouseup', ()=>{ dragState.dragging=false; resizeState.resizing=false; document.body.style.userSelect=''; });

    // URL params override
    (function(){
      const p = new URLSearchParams(window.location.search);
      const title = p.get('title');
      const img   = p.get('img');
      const site  = p.get('url');
      const font  = p.get('font');
      const dateParam = p.get('date');
      const logo  = p.get('logo');
      const colorParam = p.get('color');

      if (title && hText) { hText.innerText = title; }
      if (img) { const mi = document.getElementById('mainImage'); if (mi){ mi.src = img; mi.style.display=''; } }
      if (site) { const uEl = document.getElementById('urlText'); if (uEl) uEl.innerText = site; }
      if (font && hText) { hText.style.fontSize = font + 'px'; const fEl = document.getElementById('headlineFontSize'); if (fEl) fEl.value = font; }
      if (colorParam && hText) { hText.style.color = colorParam; const cEl=document.getElementById('headlineColor'); if (cEl) cEl.value = colorParam; }
      if (dateParam && dateParam.trim() !== '') { const dEl = document.getElementById('dateText'); if (dEl) dEl.innerText = dateParam; }
      if (logo) { const lEl = document.getElementById('logoImage'); if (lEl) lEl.src = logo; }
      setTimeout(()=>{ if (hText) { updateEditorUI(); } }, 0);
    })();

    // initial date render
    (function(){
      const today = new Date();
      const defaultDate = today.toLocaleDateString(SETTINGS.dateLocale || 'bn-BD', { day:'numeric', month:'long', year:'numeric' });
      const dEl = document.getElementById('dateText'); if (dEl) dEl.innerText = defaultDate;
    })();

    // Export only card
    document.getElementById('exportCardBtn').addEventListener('click', (e)=>{
      e.preventDefault();
      html2canvas(document.getElementById('card'), {
        useCORS:true, allowTaint:true, backgroundColor:null,
        ignoreElements: (el)=> el.classList && el.classList.contains('ui-ignore')
      }).then(canvas=>{
        const link = document.createElement('a'); link.download='photocard.png'; link.href=canvas.toDataURL(); link.click();
      });
    });
  </script>
</body>
</html>
